local hudtext={}  
local utf8=require"utf8"  
local font  
local textcolor={0x35/255,0xa2/255,0x35/255}  
local brighttextcolor={0x70/255,0xf0/255,0x70/255}  
local lines={}  
local displayedlines={}  
local currentline=1  
local currentchar=1  
local typingspeed=0.02  
local timer=0  
local startx=235  
local starty=850  
local lineheight=35  
local linedelay=math.random(0.5,1.5)  
local delaytimer=0  
function hudtext.load()  
font=love.graphics.newFont("terminaldosislight.ttf",34)  
lines={  
"Energy core levels: 87% charged.",  
"Life support systems: Optimized for dragons.",  
"Dragons Oxygen levels: Stable at 98%.",  
"Stellar radiation levels: Within safe range for whelplings.",  
"Shield integrity: 100%.",  
"Reactor core cooling: Nominal.",  
"Engine thrust output: 102% efficiency.",  
"External temperature: -273°C.",  
"Cargo bay temperature: -15°C.",  
"Tactical grid synchronization: Active.",  
"Warp drive status: Operational.",  
"Communication array status: All channels clear.",  
"Scanning deep space for anomalies...",  
"Long-range sensors detecting faint signals...",  
"Navigational coordinates locked: Sector 5-7A.",  
"Warp drive: Engaged" }  
end  
local function utf8_char_at(s,char_index)  
local i=1  
for p in utf8.codes(s) do  
if i==char_index then return string.sub(s,p,utf8.offset(s,2,p)-1) end  
i=i+1  
end  
return nil  
end  
local function split_at_colon(text)  
local ci=text:find":"  
if ci then return text:sub(1,ci),text:sub(ci+1) else return text,"" end  
end  
local function draw_bold_text(text,x,y)  
love.graphics.print(text,x,y)  
love.graphics.print(text,x+.5,y)  
love.graphics.print(text,x-.5,y)  
end  
function hudtext.update(dt)  
if currentline<=#lines then  
delaytimer=delaytimer+dt  
if delaytimer>=linedelay then  
timer=timer+dt  
if timer>=typingspeed then  
timer=timer-typingspeed  
if not displayedlines[currentline] then displayedlines[currentline]="" end  
local nc=utf8_char_at(lines[currentline],currentchar)  
if nc then displayedlines[currentline]=displayedlines[currentline]..nc end  
currentchar=currentchar+1  
if currentchar>utf8.len(lines[currentline]) then  
currentline=currentline+1 currentchar=1 delaytimer=0 linedelay=math.random(.5,.5)  
end end end end end  
function hudtext.draw()  
love.graphics.push()  
love.graphics.setFont(font)  
for i,line in ipairs(displayedlines) do  
local y=starty-((#displayedlines-i)*lineheight)  
local before,after=split_at_colon(line)  
love.graphics.setColor(textcolor)  
draw_bold_text(before,startx,y)  
if after~="" then  
local off=font:getWidth(before)  
love.graphics.setColor(brighttextcolor)  
-- CHANGED: make the 'after' text bold as well
draw_bold_text(after,startx+off,y)  
end end  
love.graphics.pop()  
love.graphics.setColor(1,1,1)  
end
return hudtext
